% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{get_jobs}
\alias{get_jobs}
\title{Get Jobs}
\usage{
get_jobs(content)
}
\arguments{
\item{content}{A Content object, as returned by \code{content_item()}}
}
\value{
A data frame with a row for each job, with the following columns:
\itemize{
\item \code{id}: The job identifier.
\item \code{ppid}: The job's parent process identifier (see Note 1).
\item \code{pid}: The job's process identifier.
\item \code{key}: The job's unique key identifier.
\item \code{remote_id}: The job's identifier for off-host execution configurations
(see Note 1).
\item \code{app_id}: The job's parent content identifier
\item \code{variant_id}: The identifier of the variant owning this job.
\item \code{bundle_id}: The identifier of a content bundle linked to this job.
\item \code{start_time}: The timestamp (RFC3339) indicating when this job started.
\item \code{end_time}: The timestamp (RFC3339) indicating when this job finished.
\item \code{last_heartbeat_time}: The timestamp (RFC3339) indicating the last time
this job was observed to be running (see Note 1).
\item \code{queued_time}: The timestamp (RFC3339) indicating when this job was added
to the queue to be processed. Only scheduled reports will present a value
for this field (see Note 1).
\item \code{queue_name}: The name of the queue which processes the job. Only
scheduled reports will present a value for this field (see Note 1).
\item \code{tag}: A tag to identify the nature of the job.
\item \code{exit_code}: The job's exit code. Present only when job is finished.
\item \code{status}: The current status of the job. On Connect 2022.10.0 and newer,
one of Active: 0, Finished: 1, Finalized: 2; on earlier versions, Active:
0, otherwise \code{NA}.
\item \code{hostname}: The name of the node which processes the job.
\item \code{cluster}: The location where this content runs. Content running on the
same server as Connect will have either a null value or the string Local.
Gives the name of the cluster when run external to the Connect host
(see Note 1).
\item \code{image}: The location where this content runs. Content running on
the same server as Connect will have either a null value or the string
Local. References the name of the target image when content runs in
a clustered environment such as Kubernetes (see Note 1).
\item \code{run_as}: The UNIX user that executed this job.
}
}
\description{
Retrieve details about server processes associated with a \code{content_item},
such as a FastAPI app or a Quarto render.
}
\details{
Note that Connect versions below 2022.10.0 use a legacy endpoint, and will
not return the complete set of information provided by newer versions.
}
\note{
\enumerate{
\item On Connect instances earlier than 2022.10.0, these columns will contain \code{NA} values.
}
}
\seealso{
Other job functions: 
\code{\link{get_job}()},
\code{\link{terminate_jobs}()}

Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
\concept{job functions}
