% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{add_datasource}
\alias{add_datasource}
\title{Add a new datasource to a YAML configuration file}
\usage{
add_datasource(config_path, name, backend)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{name}{The name of the new datasource}

\item{backend}{A named list representing the backend configuration for the new datasource}
}
\value{
The updated configuration after adding the new datasource
}
\description{
This function adds a new datasource to a YAML configuration file by appending the
provided datasource information to the existing datasources.
}
\examples{

# Read the YAML file
test_config <- system.file("config", "default_config.yml", package = "connector")
file.copy(test_config, "test_config.yaml")

# Add a new datasource
# Define the backend as a named list
new_backend <- list(
  type = "connector_fs",
  path = "test"
)

# Add a new datasource with the defined backend
config <- add_datasource("test_config.yaml", "new_datasource", new_backend)

unlink("test_config.yaml")

}
