% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{remove_metadata}
\alias{remove_metadata}
\title{Remove metadata from a YAML configuration file}
\usage{
remove_metadata(config_path, key)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{key}{The key for the metadata entry to be removed}
}
\value{
(invisible) \code{config_path} where the configuration have been updated
}
\description{
This function removes metadata from a YAML configuration file by deleting
the specified key from the metadata section of the file.
}
\examples{
config <- tempfile(fileext = ".yml")

file.copy(
  from = system.file("config", "_connector.yml", package = "connector"),
  to = config
)

config |>
  add_metadata(
    key = "new_metadata",
    value = "new_value"
  ) |>
  remove_metadata("new_metadata")

}
