% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoHelpers.R
\name{infoFunc}
\alias{infoFunc}
\title{infoFunc}
\usage{
infoFunc(
  myItems,
  myAbilities,
  type = "empirical",
  minTheta = NA,
  maxTheta = NA,
  stepTheta = NA
)
}
\arguments{
\item{myItems}{A vector of item deltas.}

\item{myAbilities}{A vector of person abilities.}

\item{type}{A character String.
Should the test information be calculated empirically ("empirical" - default) or analytically using moments of distribution ("approx").}

\item{minTheta}{The smallest value of ability PDF to plot.}

\item{maxTheta}{The largest value of ability PDF to plot.}

\item{stepTheta}{The increment to iterate over the ability PDF. Defaults to 0.01.}
}
\value{
A data frame.
}
\description{
Calculate test information function, given a vector of item difficulties and a vector of abilities.
Returns a data frame that can be easily plotted.
}
\examples{
myInfo<- infoFunc(runif(10, -2, 3), rnorm(1000, 0, 1))
}
