% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{cnvrtItemParam}
\alias{cnvrtItemParam}
\title{cnvrtItemParam}
\usage{
cnvrtItemParam(item, from = "muraki", to = "conquest", D = 1)
}
\arguments{
\item{item}{an item design matrix that is of size response categories (m) by four:
\itemize{
\item column one is category values, usually from 0 to m. Sometimes referred to as 'x',
and in this case, this value times the discrimination is the category score.
\item column two is the delta dot parameter repeated m times (the average difficulty of the item)
\item column three is the tau (step) parameter where for the first response category (x = 0) tau = 0,
and for m >= 2, entries are deviations from delta dot. In the dichotomous case, all items
in this column are zero.
\item column four is the discrimination parameter ("a")
}}

\item{from}{a string, either "muraki"  or "conquest" (default) (see 10.1177/0146621697211001).
Describing the parameterisation of \emph{item}}

\item{to}{a string, either "muraki"  or "conquest" (default) (see 10.1177/0146621697211001).
Describing the output parameterisation of the returned \emph{item} parameter matrix
Note that "muraki" assumes the scaling constant D = 1.7 (to give the normal ogive metric)}

\item{D}{a number, giving the scaling constant. Default is 1 (logistic metric).
Other common values are D = 1.7 (to give the normal ogive metric)}
}
\value{
an m x 4 matrix of item parameters. The same dimensions as the input, \emph{item}
}
\description{
takes an item in one model's parameterisation and
returns it in another parameterisation.
}
\examples{
myTheta <- 0
myDelta <- 1.5
a <- 1.5
m <- 3
itemParamX <- seq(0, m-1, 1)
itemParamD <- rep(myDelta, m)
itemParamT <- c(0, -0.5, 0.5)
itemParamA <- rep(a, m)
itemParam <- cbind(itemParamX, itemParamD, itemParamT, itemParamA)
colnames(itemParam)<- c("x", "d", "t", "a")
myItem <- cnvrtItemParam(itemParam, from = "conquest", to = "muraki")
}
