% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{syms}
\alias{syms}
\alias{syms_with_errors}
\alias{syms_with_units}
\title{Lists Containing All Symbols.}
\format{An object of class list or NULL (if not available).}
\usage{
syms

syms_with_errors

syms_with_units
}
\description{
These lists contain the named values for all the fundamental physical constants.
}
\details{
\code{syms} contains plain numeric values. \code{syms_with_errors} contains
objects of type \code{errors}, which encloses values with absolute errors and enables
automatic error propagation (only available if the \code{errors} package is installed;
see the documentation of that package for further information). \code{syms_with_units}
contains objects of type \code{units}, which encloses values with units and enables
automatic conversion, derivation and simplification (only available if the \code{units}
package is installed; see the documentation of that package for further information).
}
\examples{
# the speed of light
with(syms, c0)

# the Planck constant
attach(syms)
hbar

detach(syms); attach(syms_with_errors)
hbar

detach(syms_with_errors); attach(syms_with_units)
hbar

}
\seealso{
\code{\link{codata}}, \code{\link{lookup}}.
}
\keyword{datasets}
