% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact_matrix.R
\name{contact_matrix}
\alias{contact_matrix}
\title{Get contact data matrix for a specific country}
\usage{
contact_matrix(country, location = c("all", "home", "school", "work", "other"))
}
\arguments{
\item{country}{Character. The name of the country for which you want contact
data.}

\item{location}{Character. One of "all", "home", "school", "work" or "other".}
}
\value{
A square (16 by 16) matrix containing the contact data between
the different age classes for a given country.
}
\description{
Get contact data matrix for a specific country
}
\examples{
contact_matrix("France", location = "all")

contact_matrix("Belgium", location = "school")

}
\references{
Kiesha Prem, Alex R. Cook, Mark Jit, Projecting social contact
matrices in 152 countries using contact surveys and demographic data, PLoS
Comp. Biol. (2017), \doi{10.1371/journal.pcbi.1005697}
}
