% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discard_at.R
\name{discard_at}
\alias{discard_at}
\alias{ref_discard_at}
\alias{discard_at.Container}
\alias{ref_discard_at.Container}
\alias{discard_at.dict.table}
\alias{ref_discard_at.dict.table}
\title{Discard Elements at Indices}
\usage{
discard_at(.x, ...)

ref_discard_at(.x, ...)

\method{discard_at}{Container}(.x, ...)

\method{ref_discard_at}{Container}(.x, ...)

\method{discard_at}{dict.table}(.x, ...)

\method{ref_discard_at}{dict.table}(.x, ...)
}
\arguments{
\item{.x}{any \code{R} object.}

\item{...}{indices at which values are to be discarded.}
}
\value{
For \code{Container}, an object of class \code{Container} (or one of the
respective derived classes).

For \code{dict.table}, an object of class \code{dict.table}.
}
\description{
Search and remove values at given indices, which can be numeric or character
or both. Invalid indices are ignored.
}
\examples{

co = container(a = 1, b = 2, 3)
discard_at(co, "a", "b")         # [3]
discard_at(co, 1:2)              # [3]
discard_at(co, "a", 3)           # [b = 2]
discard_at(co, "x")              # ignored

dit = as.dict.table(head(sleep))
discard_at(dit, "ID")
discard_at(dit, "ID", 1)
discard_at(dit, "foo")  # ignored
}
