% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops-compare.R
\name{OpsCompare}
\alias{OpsCompare}
\alias{==.Container}
\alias{!=.Container}
\alias{<.Container}
\alias{>.Container}
\alias{<=.Container}
\alias{>=.Container}
\title{Comparison Operators}
\usage{
\method{==}{Container}(x, y)

\method{!=}{Container}(x, y)

\method{<}{Container}(x, y)

\method{>}{Container}(x, y)

\method{<=}{Container}(x, y)

\method{>=}{Container}(x, y)
}
\arguments{
\item{x, y}{at least one must be a \code{\link[=Container]{Container()}} object (or an object of
one of the derived classes) while the other must be at least iterable.}
}
\description{
Binary comparison operators for \code{\link[=Container]{Container()}} objects and
derived classes.
}
\details{
\itemize{
\item \code{x == y} is \code{TRUE} if the contents of \code{x} and \code{y} are lexicographically \emph{equal}.
\item \code{x != y} is \code{TRUE} if the contents of \code{x} and \code{y} are \emph{not equal}.
\item \code{x < y} is \code{TRUE} if the contents of x are lexicographically \emph{less} than the
contents of y.
\item \code{x <= y} is \code{TRUE} if the contents of x are lexicographically \emph{less} than
or \emph{equal} to the contents of y.
}
}
\examples{
c1 = container(1, 2, 3)
c2 = container(1, 3, 2)
c1 == c1            # TRUE
c1 != c2            # TRUE
c1 <= c1            # TRUE
c1 == c2            # FALSE
c1 < c2             # TRUE
c1 < container(2)   # TRUE
c1 < container()    # FALSE

}
