% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FleissEveritt_test_paired_cxc.R
\name{FleissEveritt_test_paired_cxc}
\alias{FleissEveritt_test_paired_cxc}
\title{The Fleiss-Everitt version of the Stuart test for marginal homogeneity}
\usage{
FleissEveritt_test_paired_cxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a cxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the probability, the statistic and the degrees of freedom
}
\description{
The Fleiss-Everitt version of the Stuart test for marginal homogeneity

Described in Chapter 9 "The Paired cxc Table"
}
\examples{
# From Table 13.6, page 382, of Fleiss et al. (2003)
n <- rbind(c(35, 5, 0), c(15, 20, 5), c(10, 5, 5))
FleissEveritt_test_paired_cxc(n)
}
