% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR_test_2x2.R
\name{LR_test_2x2}
\alias{LR_test_2x2}
\title{The likelihood ratio test for association in 2x2 tables}
\usage{
LR_test_2x2(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A vector containing the two-sided p-value, the statistic and the degrees of freedom
}
\description{
The likelihood ratio test for association in 2x2 tables

Described in Chapter 4 "The 2x2 Table"
}
\examples{
n <- rbind(c(3, 1), c(1, 3)) # Example: A lady tasting a cup of tea
LR_test_2x2(n)
n <- rbind(c(7, 27), c(1, 33)) # Example: Perondi et al. (2004)
LR_test_2x2(n)
n <- rbind(c(9, 4), c(4, 10)) # Example: Lampasona et al. (2013)
LR_test_2x2(n)
n <- rbind(c(0, 16), c(15, 57)) # Example: Ritland et al. (2007)
LR_test_2x2(n)
}
