% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_by_linear_test_rxc.R
\name{linear_by_linear_test_rxc}
\alias{linear_by_linear_test_rxc}
\title{The linear-by-linear test for association}
\usage{
linear_by_linear_test_rxc(
  n,
  a = seq_len(ncol(n)),
  b = seq_len(nrow(n)),
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed table (an rxc matrix)}

\item{a}{scores assigned to the rows}

\item{b}{scores assigned to the columns}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
a list containing the linear-by-linear test statistic
}
\description{
The linear-by-linear test for association

Described in Chapter 7 "The rxc Table"
}
\examples{
#' # Colorectal cancer (Table 7.7)
n <- rbind(
  c(2, 4, 29, 19), c(7, 6, 116, 51), c(19, 27, 201, 76), c(18, 22, 133, 54)
)
linear_by_linear_test_rxc(n)

\dontrun{
# Breast Tumor (Table 7.8)
n <- matrix(
  c(15, 35, 6, 9, 6, 2, 4, 2, 11, 11, 0, 0, 1, 10, 21),
  ncol = 5, byrow = TRUE
)
linear_by_linear_test_rxc(n)

# Self-rated health (Table 7.9)
n <- matrix(
  c(2, 3, 3, 3, 2, 58, 98, 14, 8, 162, 949, 252, 4, 48, 373, 369),
  ncol = 4, byrow = TRUE
)
linear_by_linear_test_rxc(n)
}
}
