% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_rxc_table.R
\name{the_rxc_table}
\alias{the_rxc_table}
\title{The rxc table}
\usage{
the_rxc_table(n, alpha = 0.05, nboot = 10000)
}
\arguments{
\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{nboot}{number of boostrap samples. If 0, skips tests that use
bootstrapping}
}
\value{
NULL. This function should be called for its printed output.
}
\description{
The rxc table
}
\examples{
set.seed(8047)
# Unordered tables

## Treatment for ear infection (van Balen et al., 2003)
the_rxc_table(table_7.3, nboot = 200)

## Psychiatric diagnoses vs PA (Mangerud et al., 2004)
the_rxc_table(table_7.4, nboot = 0)

# Singly ordered tables

## Psychiatric diag. vs BMI (Mangerud et al., 2004)
the_rxc_table(table_7.5, nboot = 0)

## Low birth weight vs psychiatric morbitidy (Lund et al., 2012)
the_rxc_table(table_7.6, nboot = 150)

# Doubly ordered tables

## Colorectal cancer (Jullumstroe et al., 2009)
the_rxc_table(table_7.7, nboot = 0)

## Breast Tumor (Bofin et al., 2004)
the_rxc_table(table_7.8, nboot = 200)

## Self-rated health (Breidablik et al., 2008)
the_rxc_table(table_7.9, nboot = 0)
}
