% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{DIRICHLET}
\alias{DIRICHLET}
\alias{new_DIRICHLET}
\title{Factory for a DIRICHLET distribution object}
\usage{
new_DIRICHLET(p_alpha, p_dimnames)
}
\arguments{
\item{p_alpha}{k-value vector for concentration parameter. Must be positive}

\item{p_dimnames}{A vector of characters for the names of the k-dimensions}
}
\value{
An object of class \code{DISTRIBUTION},
 \code{p_distribution$distribution}, \code{TRUNCATED}
}
\description{
Returns an \code{DIRICHLET} distribution object that draw random numbers
generated by the function \code{\link[extraDistr]{rdirichlet}}
}
\details{
A name can be provided for the dimensions. Otherwise \code{rvar1},
\code{rvar2}, ..., \code{rvark} will be assigned
}
\examples{
myDistr <- new_DIRICHLET(c(0.3,0.2,0.5), c("a","b","c"))
myDistr$rfunc(10)
}
\author{
John J. Aponte
}
