% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upDo_CoDi.R
\name{upDo_CoDi}
\alias{upDo_CoDi}
\title{Upward-downward convergence declaration}
\usage{
upDo_CoDi(
  myTB,
  timeName = "time",
  indiType = "highBest",
  time_0 = NA,
  time_t = NA,
  heter_fun = "pop_var"
)
}
\arguments{
\item{myTB}{time by member states dataset. No other variables can
be in the dataset.}

\item{timeName}{name of the variable that contains time.}

\item{indiType}{a string, "lowBest" or "highBest".}

\item{time_0}{reference time.}

\item{time_t}{target time strictly larger than time_0.}

\item{heter_fun}{function to summarize dispersion, like var(),
sd(); user-developed function
are allowed; pop_var is the variance with denominator n.}
}
\value{
list of declarations.
}
\description{
Convergence and divergence may be strict or weak, upward or
downward. The interpretation depends on the type of indicator,
that is "highBest" or "lowBest".
}
\details{
Note that if the argument heter_fun is set to sd or var,
then those statistics use a denominator which is n-1, i.e.
the number of observations decreased by 1.
This is not typically what one wants here, thus
the function pop_var may be used instead, because it adopts n as denominator.
It is also possible to map a summary of dispersion with a
monotonic function, like sqrt (see examples).

All the Member states contributing to the mean must be columns
of the dataset given as input.
}
\examples{

# using the standard deviation
upDo_CoDi(emp_20_64_MS,
         timeName = "time",
         indiType = "highBest",
         time_0 = 2010,
         time_t = 2015,
         heter_fun = "var" # watchout the denominator here is n-1
         )


# using the standard pop_var function
upDo_CoDi(emp_20_64_MS,
         timeName = "time",
         indiType = "highBest",
         time_0 = 2010,
         time_t = 2015,
         heter_fun = "pop_var" # the denominator here is n
         )



# using personalized summary of dispersion
diffQQmu <-  function(vettore){
   (quantile(vettore,0.75)-quantile(vettore,0.25))/mean(vettore)
   }

upDo_CoDi(emp_20_64_MS,
         timeName = "time",
         indiType = "highBest",
         time_0 = 2010,
         time_t = 2015,
         heter_fun = "diffQQmu"
         )

}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
