% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_dynam.R
\name{ms_dynam}
\alias{ms_dynam}
\title{Member state dynamics}
\usage{
ms_dynam(
  myTB,
  timeName = "time",
  displace = 0.25,
  displaceh = 0.45,
  dimeFontNum = 5,
  myfont_scale = 1.35,
  x_angle = 45,
  axis_name_y = "Countries",
  axis_name_x = "Time",
  alpha_color = 0.9,
  indiType = "highBest"
)
}
\arguments{
\item{myTB}{dataset time by countries.}

\item{timeName}{a string, name of the time variable.}

\item{displace}{rectangle half height.}

\item{displaceh}{rectangle half base.}

\item{dimeFontNum}{size of font.}

\item{myfont_scale}{axes magnification.}

\item{x_angle}{angle of x axis labels.}

\item{axis_name_y}{name of y axis.}

\item{axis_name_x}{name of x axis.}

\item{alpha_color}{transparency.}

\item{indiType}{is a string: "highBest" or "lowBest" to define the type
of indicator.}
}
\value{
a ggplot object to be displayed or saved using ggsave.
}
\description{
A ggplot object time by countries where coloured rectangles show the departure
from the mean after partitioning into intervals (-Inf, m-1 s, m-0.5 s, m+0.5 s, m+1 s, Inf).
Note that the following convention is adopted where the colour of labels changes depending on the type of indicator,
i.e. "lowBest" or "highBest":
}
\details{
* (-Inf, m -1 s] is labeled as -1; it is coloured in dark green for "lowBest" type of indicator
   and in red for "highBest" type of indicator;
* (m -1 s, m -0.5 s] is labeled as -0.5; it is coloured in pale green for "lowBest" type of indicator
   and in yellow (ocra) for "highBest" type of indicator;
* (m -0.5 s,m +0.5 s ] is labeled as 0; it is coloured in pale yellow for both "lowBest" and "highBest
   types of indicators;
* (m +0.5 s, m +1 s] is labeled as 0.5; it is coloured in  yellow (ocra) for "lowBest" type of indicator
  and in pale green for "highBest" type of indicator;
* (m +1 s, Inf] is labeled as 1; it is coloured in red for "lowBest" type of indicator
   and in dark green for "highBest" type of indicator.
}
\examples{

\donttest{

# Example 1: "lowBest" type of indicator:
# Dataset in the format time by countries:
require(tibble)
testTB <- dplyr::tribble(
    ~time, ~countryA ,  ~countryB,  ~countryC,
    2000,     0.8,   2.7,    3.9,
    2001,     1.2,   3.2,    4.2,
    2002,     0.9,   2.9,    4.1,
    2003,     1.3,   2.9,    4.0,
    2004,     1.2,   3.1,    4.1,
    2005,     1.2,   3.0,    4.0
    )

# Calculate scoreboards for countries:
res<-scoreb_yrs(testTB, timeName = "time")

# Extract the component "sco_level_num" from "res"
resTB<-res$res$sco_level_num

# Plot the departures from the mean for each country:
ms_dynam ( resTB,
    timeName = "time",
    displace = 0.25,
    displaceh = 0.45,
    dimeFontNum = 5,
    myfont_scale = 1.35,
    x_angle = 45,
    axis_name_y = "Countries",
    axis_name_x = "Time",
    alpha_color = 0.9,
    indiType = "lowBest")

# Plot the departures from the mean for some years only:
# Extract results from sco_level_num" for some years only:
estrattore <- resTB[["time"]] >= 2001 & resTB[["time"]] <= 2004
scobelvl <- dplyr::filter(resTB, estrattore)

# Plot the countries dynamics
ms_dynam ( scobelvl,
    timeName = "time",
    displace = 0.25,
    displaceh = 0.45,
    dimeFontNum = 5,
    myfont_scale = 1.35,
    x_angle = 45,
    axis_name_y = "Countries",
    axis_name_x = "Time",
    alpha_color = 0.9,
    indiType = "lowBest"
    )

# Example 2: "highBest" type of indicator:
# Scoreboards of Member States for the emp_20_64_MS Eurofound dataset:
data(emp_20_64_MS)

# Extract the component "sco_level_num
sco_lvl <- scoreb_yrs(emp_20_64_MS,timeName = "time")$res$sco_level_num

# Extract the results from 2009 to 2016
estrattore1 <- sco_lvl[["time"]] >= 2009 & sco_lvl[["time"]] <= 2016
scobelvl1 <- dplyr::filter(sco_lvl, estrattore1)
# Plot the departures from the mean for the EU Member States:
ms_dynam( scobelvl1,
    timeName = "time",
    displace = 0.25,
    displaceh = 0.45,
    dimeFontNum = 3,
    myfont_scale = 1.35,
    x_angle = 45,
    axis_name_y = "Countries",
    axis_name_x = "Time",
    alpha_color = 0.9,
    indiType = "highBest")

# Extract the results for Member States from 2007 to 2012:
estrattore2 <- sco_lvl[["time"]] >= 2007 & sco_lvl[["time"]] <= 2012
scobelvl2 <- dplyr::filter(sco_lvl, estrattore2)

# Plot the departures from the mean:
ms_dynam( scobelvl2,
    timeName = "time",
    displace = 0.25,
    displaceh = 0.45,
    dimeFontNum = 3,
    myfont_scale = 1.35,
    x_angle = 45,
    axis_name_y = "Countries",
    axis_name_x = "Time",
    alpha_color = 0.9,
    indiType = "highBest")
}


}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
