% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCsCt.r
\name{calcCsCt}
\alias{calcCsCt}
\title{Computes Ct values for a pair of tips. Internal, called in calcConv.}
\usage{
calcCsCt(
  tips,
  ancList,
  allDists,
  phy,
  VERBOSE = FALSE,
  allVals,
  edge,
  lim.height = NULL
)
}
\arguments{
\item{tips}{vector of two tips}

\item{ancList}{list of node paths for all tips in the user provided phylogeny}

\item{allDists}{matrix of phenotypic distances between all exterior and interior node pairs}

\item{phy}{The time calibrated phylogeny of interest in phylo format}

\item{VERBOSE}{logical value indicating whether model information should be printed during computation}

\item{allVals}{a matrix of observed and reconstructed phenotypes for all user supplied traits at interior and exterior nodes}

\item{edge}{a list of data frames, each including the edge matrix of user supplied phylogeny, along with node heights and reconstructed phenotype for each of the user supplied traits}

\item{lim.height}{an optional tree height used to limit Dmax.t, passed only if groups are defined and a conservative test is run (see calcConv)}
}
\value{
A list of the Ct values
}
\description{
calcCsCt Computes Ct values for a pair of tips. Internal, called in calcConv.
}
\details{
Function incorporates the optimizations introduced by Zelditch et al. (2017), which significantly improve runtimes

Reconstructions part way along branches are obtained using equation [2] of Felsenstein (1985), following code modified from the phytools (Revell, 2012) function contMap
}
\references{
Grossnickle DM, Brightly WH, Weaver LN, Stanchak KE, Roston RA, Pevsner SK, Stayton CT, Polly PD, Law CJ. 2022. A cautionary note on quantitative measures of phenotypic convergence. in revision
Zelditch ML, Ye J, Mitchell JS, Swiderski DL. 2017. Rare ecomorphological convergence on a complex adaptive landscape: Body size and diet mediate evolution of jaw shape in squirrels (Sciuridae). Evolution 71: 633-649
Stayton CT. 2015. The definition, recognition, and interpretation of convergent evolution and two new measures for quantifying and assessing the significance of convergence. Evolution 69(8): 2140-2153.
Revell, L. J. (2012) phytools: An R package for phylogenetic comparative biology (and other things). Methods Ecol. Evol., 3, 217-223.
Felsenstein, J. 1985. Phylogenies and the comparative method. American Naturalist, 125, 1-15.
}
