% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DataDocumentation.R
\docType{data}
\name{simdata}
\alias{simdata}
\title{Simulated nonstationary dataset}
\format{A list with the following objects:
\describe{
   \item{sim.locations}{A matrix of longitude/latitude coordinates of the
   simulated locations.}
   \item{mc.locations}{A matrix of longitude/latitude coordinates of the
   mixture component locations.}
   \item{mc.kernel}{A three-dimensional array, containing the true 2 x 2
   kernel covariance matrices for each mixture component location.}
   \item{kernel.ellipses}{A three-dimensional array, containing the true 2 x 2
   kernel covariance matrices for each simulated location.}
   \item{sim.data}{A matrix of the simulated data; each of the ten columns
   correspond to an independent and identically distribured replicate.}
   \item{lambda.w}{Scalar; the value of the tuning parameter used in the
   weight function.}
   \item{holdout.index}{Vector; indicates which of the simulated locations
   should be used in the hold-out sample.}

}}
\usage{
simdata
}
\description{
A data set containing the necessary components to fit the nonstationary
spatial model, simulated from the true model.
}
\keyword{datasets}

