% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encryption.r
\name{encrypt_vec}
\alias{encrypt_vec}
\alias{decrypt_vec}
\title{Encrypts/Decrypts a vector}
\usage{
encrypt_vec(vec)

decrypt_vec(vec)
}
\arguments{
\item{vec}{A vector of values to encrypt}
}
\value{
list of encrypted elements (for \code{encrypt_vec}); vector of
decrypted elements (for \code{encrypt_vec}).
}
\description{
Used internally to encrypt/decrypt the value column of your
cookie jar.
}
\details{
If you save valuable cookies, for example login information, you
should encrypt them with a personalised password. This can be set with,
e.g., \code{Sys.setenv("COOKIE_KEY" = "megageheim")} or in an
.Renviron file.
}
\examples{
enc <- encrypt_vec(c("foo", "bar"))
decrypt_vec(enc)

}
