% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metrop_run}
\alias{metrop_run}
\title{Run the hierarchical mcmc model to infer priors}
\usage{
metrop_run(
  lbf_mat,
  nsnps,
  covar_vec,
  covar = FALSE,
  nits = 10000L,
  thin = 1L,
  alpha_mean = -10,
  alpha_sd = 0.5,
  beta_shape = 2,
  beta_scale = 2,
  gamma_shape = 2,
  gamma_scale = 2
)
}
\arguments{
\item{lbf_mat}{matrix of log bayes factors: lBF.Ha and lBF.Hc}

\item{nsnps}{number of snps}

\item{covar_vec}{Vector of the covariate}

\item{covar}{logical: Should the covariate inflormation be used? default: False}

\item{nits}{Number of iterations run in mcmc}

\item{thin}{thinning}

\item{alpha_mean}{prior for the mean of  alpha}

\item{alpha_sd}{prior for the standard deviation of  alpha}

\item{beta_shape}{prior for the shape (gamma distibution) of beta}

\item{beta_scale}{prior for the scale of beta}

\item{gamma_shape}{prior for the shape (gamma distibution) of gamma}

\item{gamma_scale}{prior for the scale of gamma}
}
\value{
named list of log likelihood (ll) and parameters: alpha, beta and gamma
}
\description{
Run the hierarchical mcmc model to infer priors
}
