/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset.neigh;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.SubsetNeighbourhood;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;
import org.jamesframework.core.subset.neigh.moves.SwapMove;
import org.jamesframework.core.util.SetUtilities;

public class SingleSwapNeighbourhood
extends SubsetNeighbourhood {
    public SingleSwapNeighbourhood() {
        this(null);
    }

    public SingleSwapNeighbourhood(Set<Integer> fixedIDs) {
        super(fixedIDs);
    }

    public SubsetMove getRandomMove(SubsetSolution solution, Random rnd) {
        Set<Integer> removeCandidates = this.getRemoveCandidates(solution);
        Set<Integer> addCandidates = this.getAddCandidates(solution);
        if (removeCandidates.isEmpty() || addCandidates.isEmpty()) {
            return null;
        }
        int del = SetUtilities.getRandomElement(removeCandidates, rnd);
        int add = SetUtilities.getRandomElement(addCandidates, rnd);
        return new SwapMove(add, del);
    }

    @Override
    public List<SubsetMove> getAllMoves(SubsetSolution solution) {
        Set<Integer> removeCandidates = this.getRemoveCandidates(solution);
        Set<Integer> addCandidates = this.getAddCandidates(solution);
        if (removeCandidates.isEmpty() || addCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        return addCandidates.stream().flatMap(add -> removeCandidates.stream().map(remove -> new SwapMove((int)add, (int)remove))).collect(Collectors.toList());
    }
}

