/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

public enum CoreHunterObjectiveType {
    AV_ENTRY_TO_NEAREST_ENTRY("Average Entry to Nearest Entry", "EN"),
    AV_ACCESSION_TO_NEAREST_ENTRY("Average Accession to Nearest Entry", "AN"),
    AV_ENTRY_TO_ENTRY("Average Entry to Entry", "EE"),
    SHANNON_DIVERSITY("Shannon diversity index", "SH"),
    HETEROZYGOUS_LOCI("Expected proportion of heterozygous loci per individual", "HE"),
    COVERAGE("Coverage", "CV");

    private String name;
    private String abbreviation;

    private CoreHunterObjectiveType(String name, String abbreviation) {
        this.name = name;
        this.abbreviation = abbreviation;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAbbreviation() {
        return this.abbreviation;
    }

    public String toString() {
        return this.name;
    }

    public static CoreHunterObjectiveType createFromAbbreviation(String abbr) {
        CoreHunterObjectiveType[] objs;
        for (CoreHunterObjectiveType obj : objs = CoreHunterObjectiveType.values()) {
            if (!obj.getAbbreviation().equals(abbr)) continue;
            return obj;
        }
        return null;
    }
}

