/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public final class SetUtilities {
    public static <T> T getRandomElement(Set<? extends T> set, Random rg) {
        Iterator<T> it = set.iterator();
        int r = rg.nextInt(set.size());
        T selected = it.next();
        for (int i = 0; i < r; ++i) {
            selected = it.next();
        }
        return selected;
    }

    public static <T> Collection<T> getRandomSubset(Set<? extends T> set, int size, Random rg, Collection<T> subset) {
        if (size < 0 || size > set.size()) {
            throw new IllegalArgumentException("Error in SetUtilities: desired subset size should be a number in [0,|set|].");
        }
        int remainingToSelect = size;
        int remainingToScan = set.size();
        Iterator<T> it = set.iterator();
        while (remainingToSelect > 0) {
            T item = it.next();
            if (remainingToSelect == remainingToScan || rg.nextDouble() < (double)remainingToSelect / (double)remainingToScan) {
                subset.add(item);
                --remainingToSelect;
            }
            --remainingToScan;
        }
        return subset;
    }

    public static <T> Set<T> getRandomSubset(Set<? extends T> set, int size, Random rg) {
        LinkedHashSet subset = new LinkedHashSet();
        SetUtilities.getRandomSubset(set, size, rg, subset);
        return subset;
    }
}

