/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.distance.eval;

import java.util.HashMap;
import java.util.Map;
import org.corehunter.objectives.distance.eval.NearestEntry;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;

public class NearestEntryEvaluation
implements Evaluation {
    private final Map<Integer, NearestEntry> nearestEntryMap;
    private double minDistSum;
    private final double emptyValue;

    public NearestEntryEvaluation(double emptyValue) {
        this.nearestEntryMap = new HashMap<Integer, NearestEntry>();
        this.minDistSum = 0.0;
        this.emptyValue = emptyValue;
    }

    public NearestEntryEvaluation(NearestEntryEvaluation toCopy) {
        this.nearestEntryMap = new HashMap<Integer, NearestEntry>(toCopy.nearestEntryMap);
        this.minDistSum = toCopy.minDistSum;
        this.emptyValue = toCopy.emptyValue;
    }

    public void add(int itemId, NearestEntry nearestEntry) {
        this.minDistSum += nearestEntry.getDistance();
        this.nearestEntryMap.put(itemId, nearestEntry);
    }

    public boolean remove(int itemId) {
        if (this.nearestEntryMap.containsKey(itemId)) {
            this.minDistSum -= this.nearestEntryMap.get(itemId).getDistance();
            this.nearestEntryMap.remove(itemId);
            return true;
        }
        return false;
    }

    public boolean update(int itemId, NearestEntry nearestEntry) {
        if (this.nearestEntryMap.containsKey(itemId)) {
            this.minDistSum -= this.nearestEntryMap.get(itemId).getDistance();
            this.minDistSum += nearestEntry.getDistance();
            this.nearestEntryMap.put(itemId, nearestEntry);
            return true;
        }
        return false;
    }

    public NearestEntry getClosest(int itemId) {
        return this.nearestEntryMap.get(itemId);
    }

    @Override
    public double getValue() {
        int n = this.nearestEntryMap.size();
        return n > 0 ? this.minDistSum / (double)n : this.emptyValue;
    }
}

