% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbRao.R
\name{pbRao}
\alias{pbRao}
\title{Parametric bootstrap Rao test}
\usage{
pbRao(mod, mod_null, B = 1000)
}
\arguments{
\item{mod}{an object of class \code{bbdml}}

\item{mod_null}{an object of class \code{bbdml}, should be nested within \code{mod}}

\item{B}{Integer. Defaults to \code{1000}. Number of bootstrap iterations.}
}
\value{
P-value from parametric bootstrap Rao test.
}
\description{
Parametric bootstrap Rao test
}
\examples{
data(soil_phylum_small_otu1)
mod1 <- bbdml(formula = cbind(W, M - W) ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small_otu1)

mod2 <- bbdml(formula = cbind(W, M - W) ~ 1,
phi.formula = ~ 1,
data = soil_phylum_small_otu1)
pbRao(mod1, mod2, B = 10)
}
