% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{plot_coef}
\alias{plot_coef}
\title{Plot the estimated regression coefficients and credible intervals}
\usage{
plot_coef(
  post_coefficients_1,
  post_coefficients_2 = NULL,
  alpha = 0.05,
  labels = NULL
)
}
\arguments{
\item{post_coefficients_1}{\code{Nsims x p} matrix of simulations from the posterior
distribution of the \code{p} coefficients, where \code{Nsims} is the number of simulations}

\item{post_coefficients_2}{\code{Nsims x p} matrix of simulations from the posterior
distribution of the \code{p} coefficients from another model}

\item{alpha}{confidence level for the credible intervals}

\item{labels}{\code{p} dimensional string of labels for the coefficient names}
}
\value{
A plot of regression coefficients and credible intervals for 1-2 models
}
\description{
Plot the estimated regression coefficients and credible intervals
for the linear effects in up to two models.
}
