% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{eval_distance}
\alias{eval_distance}
\title{Evaluates a distance function and checks for correct output format}
\usage{
eval_distance(distance_function, x, y, data = NULL)
}
\arguments{
\item{distance_function}{(\verb{function()})\cr
A distance function to evaluate.}

\item{x}{(\code{data.frame() | numeric()})\cr
A matrix or a data frame containing variables that should be used in the computation of the distance.}

\item{y}{(\code{data.frame() | numeric()})\cr
A matrix or a data.frame containing variables that should be used in the computation of the distance.}

\item{data}{(\code{data.frame()} | \code{NULL})\cr
A data.frame or data.table containing the entire data set. This can be used to compute statistics used in the
computation of the distance, e.g., standard deviation or range.}
}
\description{
This function serves as an evaluation wrapper for some distance function. It checks that the output
of \code{distance_function} is a \code{numeric} matrix with \code{nrow(x)} rows and \code{nrow(y)} columns as expected.
}
