% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitlist.R
\name{decide}
\alias{decide}
\title{Make a decision based on the BIC value}
\usage{
decide(summary_fit, separate)
}
\arguments{
\item{summary_fit}{a result of the \code{\link{summary_fitlist}} function.}

\item{separate}{\code{logical}. If \code{TRUE}, each count is separately 
fitted to the model. If \code{FALSE}, all counts are fitted to the same models 
having the count name as the independent variable.}
}
\description{
Select the most appropriate distribution for the count data in the html-friendly format.
}
\examples{
df <- data.frame(poisson = rpois(25, 0.3), binomial = rbinom(25, 1, 0.8))
fc <- fit_counts(df, model = "all") 
summ <- summary_fitlist(fc) 
decide(summ, separate = FALSE)
}
\seealso{
\code{\link{fit_counts}}
}
