% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_country.R
\name{is_country}
\alias{is_country}
\title{Tests whether a string is a country name}
\usage{
is_country(x, check_for = NULL, fuzzy_match = FALSE)
}
\arguments{
\item{x}{A character vector to be tested (also supports UN/ISO country codes)}

\item{check_for}{A vector of country names to narrow down testing. The function will return \code{TRUE} only if the string relates to a country in this vector. Default is NULL.}

\item{fuzzy_match}{A logical value indicating whether to tolerate small discrepancies in the country name matching. The default and fastest option is \code{FALSE}.}
}
\value{
Returns a logical vector indicating whether the string is a country name
}
\description{
This function checks whether the string is a country name. It supports different languages and naming conventions.
The function returns \code{TRUE} if it relates to one of the 249 countries of the ISO standard \code{3166}.
Alternatively, the argument \code{check_for} allows to narrow down the test to a subset of countries.
Fuzzy matching can be used to allow a small margin of error in the string.
}
\examples{
#Detect strings that are country names
is_country(x=c("ITA","Estados Unidos","Estado Unidos","bungalow","dog",542), fuzzy_match=FALSE)
is_country(x=c("ITA","Estados Unidos","Estado Unidos","bungalow","dog",542), fuzzy_match=TRUE)
#Checking for a specific subset of countries
is_country(x=c("Ceylon","LKA","Indonesia","Inde"), check_for=c("India","Sri Lanka"))
}
\seealso{
\link[countries]{match_table}, \link[countries]{country_name}, \link[countries]{find_countrycol}
}
