% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_model.R
\name{gf_model}
\alias{gf_model}
\title{Add a model to a plot}
\usage{
gf_model(object, model, ...)
}
\arguments{
\item{object}{A plot created with the \code{ggformula} package.}

\item{model}{A linear model fit by either \code{\link[=lm]{lm()}} or \code{\link[=aov]{aov()}}.}

\item{...}{Additional arguments. Typically these are (a) ggplot2 aesthetics to be set with
\code{attribute = value}, (b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object (a plot layer) that can be added to a plot.
}
\description{
When teaching about regression it can be useful to visualize the data as a point plot with the
outcome on the y-axis and the explanatory variable on the x-axis. For regression models, this is
most easily achieved by calling \code{\link[ggformula:gf_smooth]{ggformula::gf_lm()}}, with empty models
\code{\link[ggformula:gf_lines]{ggformula::gf_hline()}} using the mean, and a more complicated call to
\code{\link[ggformula:gf_segment]{ggformula::gf_segment()}} for group models. This function simplifies this
by making a guess about what kind of model you are plotting (empty/null, regression, group) and
then making the appropriate plot layer for it.
}
\details{
This function only works with models that have a continuous outcome measure.
}
