% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\docType{class}
\name{blocks-class}
\alias{blocks-class}
\alias{blocks}
\alias{boxplot,blocks-method}
\alias{blocks-method}
\alias{boxplot}
\alias{show,blocks-method}
\alias{[,blocks-method}
\alias{summary,blocks-method}
\title{Class "blocks"}
\usage{
blocks(lb, ls, matdata, pardata1, pardata2, stpairs)

\S4method{boxplot}{blocks}(x, i, j, ...)

\S4method{show}{blocks}(object)

\S4method{[}{blocks}(x, i, j)

\S4method{summary}{blocks}(object, i, j)
}
\arguments{
\item{lb}{integer, length of each block. The number of terms in each block
must be greater than 5 and smaller than the quarter part of the length of
each time series}

\item{ls}{integer, number of overlapped data between two consecutive blocks.
The number of overlapped terms between two consecutive blocks must in the
interval \eqn{[0, lb/2]}}

\item{matdata}{STFDF/STSDF or \code{data.frame}, which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable, typically output from \code{read.STdata}}

\item{pardata1}{integer, it represents the column in which the spatial ID is
stored (if the spatio-temporal data set is given as data.frame) or the number
of variables in the STFDF/STSDF (if the data are given as a STFDF/STSDF)}

\item{pardata2}{integer, it represents the column in which the values of the
variable are stored (if the spatio-temporal data set is given as data.frame)
or the slot in which the values of the variable of interest are stored
(if the data are given as a STFDF/STSDF). Note that for STFDF/STSDF the
argument is set, by default, equal to 1 if the number of variables is equal
to 1}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{x}{object of class \code{blocks} for methods \code{boxplot} and \code{extract}}

\item{i}{index specifing the block to be selected. If \code{i=0} all blocks are
selected automatically (option available only for \code{boxplot} and \code{summary}
methods)}

\item{j}{index specifing the spatial point to be selected. If \code{j=0} all
spatial points are selected automatically (option available only for \code{boxplot}
and \code{summary} methods)}

\item{...}{any arguments that will be passed to the panel plotting functions}

\item{object}{object of class \code{blocks} for methods \code{show} and \code{summary}}
}
\description{
A class for overlapped blocks of the time series associated with the given
spatial points specified through the function \code{couples}. Thus, it is
necessary to execute \linkS4class{couples} first and then \linkS4class{blocks}
}
\details{
A message informs the user of the number of blocks extracted
}
\section{Slots}{

\describe{
\item{\code{mat.block}}{matrix of dimension (\emph{lb} x \emph{overall
number of blocks}); the columns of this matrix are associated with the
different blocks, of length equal to \code{lb}, that can be extracted
from the time series related to the selected spatial points
defined in the slot \code{stpairs} of \code{couples}, identified
as  \code{stpairs@sel.staz}}

\item{\code{array.block}}{array of dimension (\emph{lb} x \emph{number of
blocks for each selected spatial points} x \emph{number of spatial points}).
In each table of this array, the overlapped blocks for each spatial location
are available}

\item{\code{sel.staz}}{numeric or character; contains the ID codes of the selected
spatial points}
}}

\note{
\itemize{
\item "Error in matdata\eqn{[, clvr]}: subscript out of bounds" appears if \code{pardata2}
does not exist in the argument \code{matdata}

\item If "Error in matdata\eqn{[, clvr]}" appears, no data for some of the
spatial points, specified in \code{stpairs}, are available. The user has to
go back to \code{couples} and revise the vector of the selected spatial points
(\code{sel.staz} and \code{sp.couples.in} arguments)

\item A stop occurs if more than 75\% of consecutive data are missing in the time
series, since a large number of missing values do not guarantee the reliability
of the tests

\item A stop occurs if the length of the time series for each
spatial points is less than 29

\item A message appears if the length of the time series for each
spatial point is greater than 29 and less than 89, since the length of the
time series is low and may not guarantee the reliability of the tests

\item A stop occurs if more than 80\\% of consecutive data are missing in one
of the blocks, since the estimation of the covariance matrix is not reliable,
when a large number of missing values occur

\item If, in the last block of each selected spatial point, more than 15\\%
of data are missing a warning message appears, since the estimation of the
covariance matrix, when a large number of missing values occurs, is not
reliable

\item A warning message appears if the number of blocks, computed by fixing
\code{lb} and \code{ls}, is less than 5. It is convenient that the number of
blocks is close to the number of spatio-temporal comparisons defined in
\code{couples}. This avoids singolarity in computing test statistics
}
}
\examples{
# --start define the STFDF rr_13-- #
library(sp)
library(spacetime)
#library(gstat)
data(air)
ls()
if (!exists("rural")) rural = STFDF(stations, dates, data.frame(PM10 =
as.vector(air)))
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
rr_13 <- r5to10[c("DEHE046","DESN049","DETH026","DENW063","DETH061","DEBY047",
"DENW065","DEUB029","DENW068","DENI019","DEHE051","DERP016","DENI051"),
"2005::2006"]
# --end define the STFDF rr_13-- #


sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = "sym", typecode = character())

block.sym <- blocks(lb = 40, ls = 10, matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym)

### methods for blocks
#1. show
block.sym

#2. [  extract
block.sym[1,] #select the 1st block of each spatial location
block.sym[,1] #select all blocks of the 1st spatial location
block.sym[1:2, 1:3] #select the first two blocks of the first 3 spatial locations

#3. summary
summary(block.sym, 1:2, 1:3) #to obtain the summary associated to the first
#two blocks of the first 3 spatial locations

summary(block.sym, 0, 1) #to obtain the summary associated to all blocks of
#the 1st spatial location

#4. boxplot
boxplot(block.sym, 1:5, 1:2) #boxplots of the first 5 blocks of associated to
#the first 2 spatial locations

boxplot(block.sym, 0 ,1) #boxplots of all blocks of associated to the 1st
#spatial location

}
\references{
Cappello, C., De Iaco, S., Posa, D., 2018, Testing the type of
non-separability and some classes of space-time covariance function models.
Stochastic Environmental Research and Risk Assessment,
\bold{32} 17--35

Cappello, C., De Iaco, S., Posa, D., 2020, {covatest}: An {R} Package for
Selecting a Class of Space-Time Covariance Functions.
Journal of Statistical Software, \bold{94(1)} 1--42.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.
}
\seealso{
\code{\link{couples}}

\code{\link{read.STdata}}
}
