% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_epi_rates}
\alias{add_epi_rates}
\title{Adding incidence, mortality and lethality rates to the downloaded data}
\usage{
add_epi_rates(data, ...)
}
\arguments{
\item{data}{a data set downloaded using the covid19br::downloadCovid19() function.}

\item{...}{further arguments passed to other methods.}
}
\value{
the data set with the added incidence, mortality and lethality rates.
}
\description{
This function adds the incidence, mortality and lethality rates to a given data set downloaded by the covid19br::downloadCovid19() function.
}
\details{
The function add_epi_rates() was designed to work with the original names of the variables accumDeaths, accummCases and pop available in the data set downloaded by the covid19br::downloadCovid19(). For this reason, this function must be used before any change in such variable names.
}
\examples{
\donttest{
library(covid19br)
library(dplyr)

brazil <- downloadCovid19(level = "brazil")
brazil <- add_epi_rates(brazil)
glimpse(brazil)
}

}
\author{
Fabio N. Demarqui \email{fndemarqui@est.ufmg.br}
}
