% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brazil_region}
\alias{brazil_region}
\title{The dataset with information on the new Coronavirus (COVID-19) for the five regions of Brazil}
\format{
A data.frame object
}
\source{
Ministerio da Saude - Sistema Unico de Saude (SUS) \href{https://www.gov.br/saude/pt-br}{website}
}
\usage{
brazil_region
}
\value{
load the database for the current environment
}
\description{
Daily information about the new Coronavirus (COVID-19) pandemic in Brazil's regions
}
\details{
The dataset contains the daily summary of the Coronavirus pandemic cases in Brazil's regions. The data includes the following fields:

* region - String. Indicates the regions coverage (Centro-Oeste, Nordeste, Norte, Sudeste, Sul)

* date - Date. Ocurrence notification date

* epidWeek - Numeric. Epidemiological week of ocurrence by notification date

* population - Numeric. Population of the size, of each region, on the date of notification of the ocurrence

* accumCases - Numeric. Cumulative cases of COVID-19 by notification date

* newCases - Numeric. Number of new COVID-19 cases by notification date

* accumDeaths - Numeric. Accumulated COVID-19 deaths by notification date

* newDeaths - Numeric. Number of new COVID-19 deaths by notification date
}
\examples{

data (brazil_region)

}
\keyword{Brazil}
\keyword{COVID-19}
\keyword{coronavirus}
\keyword{datasets}
\keyword{sars-cov-2}
