% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid19sf_test_loc}
\alias{covid19sf_test_loc}
\title{San Francisco COVID-19 Testing Locations}
\format{
An object class sf and data.frame with 17 variables
\describe{
  \item{id}{Location ID}
  \item{medical_home}{Medical home}
  \item{name}{The medical name}
  \item{address}{The medical address}
  \item{phone_number}{The medical phone number}
  \item{phone_number_formatted}{The medical phone number formatted}
  \item{testing_hours}{The medical testing hours}
  \item{popup_or_permanent}{The medical testing type, c("Permanent", "Pop-Up" )}
  \item{location_type}{The medical location type, c("Private", "Public" )}
  \item{eligibility}{Eligibility information for accessing testing at this location}
  \item{cta_text}{The call to action used for the web map}
  \item{cta_link}{The call to action link for the button on the web map}
  \item{sample_collection_method}{The method for collecting samples at the lab}
  \item{lap}{The lab name}
  \item{latitude}{The medical latitude point}
  \item{longitude}{The medical longitude point}
  \item{geometry}{The medical geometry details}
  }
}
\source{
San Francisco, Department of Public Health - Population Health Division through San Francisco Opne Data protal \href{https://datasf.org/opendata/}{website}.
}
\usage{
covid19sf_test_loc
}
\description{
A list of testing locations including address and coordinates for mapping.
 More information about the data available \href{https://data.sfgov.org/COVID-19/COVID-19-Testing-Locations/dtit-7gp4}{here}
}
\details{
The dataset contains the San Francisco testing location information
}
\examples{
data(covid19sf_test_loc)

head(covid19sf_test_loc)

}
\keyword{COVID19}
\keyword{datasets}
\keyword{medical}
\keyword{summary}
\keyword{testing}
