% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.R
\name{chr}
\alias{chr}
\title{Case Hospitalization Rate (CHR)}
\usage{
chr(
  datos_covid,
  entidades = c("AGUASCALIENTES", "BAJA CALIFORNIA", "BAJA CALIFORNIA SUR", "CAMPECHE",
    "CHIAPAS", "CHIHUAHUA", "CIUDAD DE MÉXICO", "COAHUILA DE ZARAGOZA", "COLIMA",
    "DURANGO", "GUANAJUATO", "GUERRERO", "HIDALGO", "JALISCO", "MÉXICO",
    "MICHOACÁN DE OCAMPO", "MORELOS", "NAYARIT", "NUEVO LEÓN", "OAXACA", "PUEBLA",
    "QUERÉTARO", "QUINTANA ROO", "SAN LUIS POTOSÍ", "SINALOA", "SONORA", "TABASCO",
    "TAMAULIPAS", "TLAXCALA", "VERACRUZ DE IGNACIO DE LA LLAVE", "YUCATÁN", "ZACATECAS"),
  group_by_entidad = TRUE,
  entidad_tipo = c("Unidad Medica", "Residencia", "Nacimiento"),
  fecha_tipo = c("Sintomas", "Ingreso", "Defuncion"),
  tipo_clasificacion = c("Confirmados COVID"),
  group_by_tipo_clasificacion = FALSE,
  incluir_paciente_no_especificado = FALSE,
  tipo_sector = c("CRUZ ROJA", "DIF", "ESTATAL", "IMSS", "IMSS-BIENESTAR", "ISSSTE",
    "MUNICIPAL", "PEMEX", "PRIVADA", "SEDENA", "SEMAR", "SSA", "UNIVERSITARIO",
    "NO ESPECIFICADO"),
  group_by_tipo_sector = FALSE,
  defunciones = FALSE,
  edad_cut = NULL,
  fill_NA = TRUE,
  list_name = "case hospitalization rate",
  .grouping_vars = c()
)
}
\arguments{
\item{datos_covid}{(\strong{obligatorio}) Lista de \code{tibble}s o \code{duckdb}s resultante de
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} o \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}}

\item{entidades}{(\strong{opcional})  Vector con las entidades de las unidades medicas a analizar.
Opciones: \code{AGUASCALIENTES}, \verb{BAJA CALIFORNIA}, \verb{BAJA CALIFORNIA SUR},
\code{CAMPECHE}, \code{CHIAPAS}, \code{CHIHUAHUA}, \verb{CIUDAD DE MEXICO},
\verb{COAHUILA DE ZARAGOZA} , \code{COLIMA}, \code{DURANGO}, \code{GUANAJUATO}, \code{GUERRERO},
\code{HIDALGO}, \code{JALISCO}, \code{MEXICO}, \verb{MICHOACAN DE OCAMPO}, \code{MORELOS},\code{NAYARIT}
\verb{NUEVO LEON}, \code{OAXACA} ,\code{PUEBLA}, \code{QUERETARO},\verb{QUINTANA ROO},
\verb{SAN LUIS POTOSI}, \code{SINALOA}, \code{SONORA}, \code{TABASCO}, \code{TAMAULIPAS},\code{TLAXCALA},
\verb{VERACRUZ DE IGNACIO DE LA LLAVE}, \code{YUCATAN}, \code{ZACATECAS}.}

\item{group_by_entidad}{(\strong{opcional}) \code{TRUE} obtiene los casos para cada entidad reportando
en cada fecha la entidad y los casos en dicha entidad. \code{FALSE}  junta las \code{entidades} sumando
sus casos en una sola observacion por cada fecha.}

\item{entidad_tipo}{(\strong{opcional}) Indica a que se refiere las \code{entidades} seleccionadas. Elige
una de las opciones: \verb{Unidad Medica} (entidad de la unidad medica), \code{Nacimiento}
(entidad de origen del individuo) o \code{Residencia} (entidad donde reside el individuo).}

\item{fecha_tipo}{(\strong{opcional}) Selecciona si la fecha que se utiliza es la fecha de \code{Ingreso}
(si aplica), la fecha de \code{Sintomas} o la de \code{Defuncion} (si aplica). El default es fecha de \code{Sintomas}.}

\item{tipo_clasificacion}{(\strong{opcional})  Vector con el tipo de clasificaciones (por la prueba)
a incluir:\code{Sospechosos},\verb{Confirmados COVID}, \verb{Negativo a COVID}, \verb{Inv\\u00e1lido}, \verb{No realizado}}

\item{group_by_tipo_clasificacion}{(\strong{opcional})  Booleana determinando si regresa la base
con cada entrada agrupada por \code{tipo_clasificacion} (es decir cada fecha
se generan tantos observaciones como grupos de tipo de clasificación) en caso \code{TRUE}. Si
\code{FALSE} suma todos los casos del tipo de clasificacion por fecha dando un solo numero por fecha.
El defalt es \code{FALSE}.}

\item{incluir_paciente_no_especificado}{(\strong{opcional})  Si en el denominador se incluyen
los pacientescuyo tipo es  \verb{NO ESPECIFICADO}. Por default es \code{FALSE} por lo que sólo
se incluyen \code{AMBULATORIO}, \code{HOSPITALIZADO}.}

\item{tipo_sector}{(\strong{opcional}) Vector con los sectores del sistema de salud a incluir:
\verb{CRUZ ROJA},\code{DIF},\code{ESTATAL},\code{IMSS},\code{IMSS-BIENESTAR},\code{ISSSTE}, \code{MUNICIPAL},\code{PEMEX},
\code{PRIVADA},\code{SEDENA},\code{SEMAR},\code{SSA}, \code{UNIVERSITARIO},\verb{NO ESPECIFICADO}.
Por default se incluyen todos.}

\item{group_by_tipo_sector}{(\strong{opcional}) Booleana determina en el caso de \code{TRUE} si regresa
la base con cada entrada agrupada por \code{tipo_sector} (es decir cada fecha
tiene una entrada con los del \code{IMSS}, una entrada distinta con los de \code{ISSSTE}, etc) o bien
en caso de \code{FALSE} se devuelve una sola entrada por fecha con la suma \code{IMSS + ISSSTE + etc}
segun los  sectores seleccionados. El default es \code{FALSE}.}

\item{defunciones}{(\strong{opcional})  Booleana si incluir sólo defunciones \code{TRUE} o a todos \code{FALSE}.
El default es \code{FALSE}.}

\item{edad_cut}{(\strong{opcional}) Vector con secuencia de edades para hacer grupos. Por ejemplo
\code{edad_cut = c(0, 10, Inf)} arma dos grupos de edad de 0 a 10 y de 10 a infinito o bien
\code{edad_cut = c(15, 20)} deja sólo los registros entre 15 y 20 años. Por default es \code{NULL}
y no arma grupos etarios.}

\item{fill_NA}{(\strong{opcional})  Regresa observaciones para todas las combinaciones de variables
incluyendo como \code{NA} donde no se observaron casos en el denominador.  En caso contrario no se
incluyen las filas donde no se observaron casos.}

\item{list_name}{(\strong{opcional}) Asigna un nombre en la lista de datos a la base generada}

\item{.grouping_vars}{(\strong{opcional}) Vector de variables adicionales de agrupacion de los
conteos. Por ejemplo si se agrega \code{.grouping_vars = 'DIABETES'} entonces para cada fecha habra
dos conteos de casos uno de los que tienen diabetes y uno de los que no.}
}
\value{
Une a la lista de \code{datos_covid} una nueva entrada de nombre \code{list_name}
(default: \verb{case hospitalization rate}) con una base de datos (\code{tibble} o \code{duckdb}) con los
resultados agregados.
\itemize{
\item \verb{case hospitalization rate} - Base de datos generara con los datos agregados (el
nombre cambia si se usa \code{list_name}).
\item dict - Diccionario de datos
\item dats - Datos originales (conexion a \code{duckdb} o \code{tibble})
\item disconnect  - Función para desconectarte de \code{duckdb}
\item ... - Cualquier otro elemento que ya existiera en \code{datos_covid}
}
}
\description{
\code{chr} Calcula la proporción de enfermos que resultan hospitalizados sobre todos los enfermos
confirmados en distintas categorías (residencia / edad / etc)
}
\details{
El case hospitalization rate se define como

\deqn{\frac{\# Hospitalizados}{Total de enfermos}}{%
\# Hospitalizados / Total de enfermos}

Si se utiliza la opción \code{incluir_paciente_no_especificado} se puede cambiar la definicion
de \strong{Total de enfermos} para incluir a los pacientes que dicen \verb{NO ESPECIFICADO}. Estos
por default se excluyen justo por su naturaleza desconocida.
}
\examples{

# Para el ejemplo usaremos los datos precargados (datosabiertos) pero tu puedes
# correr el ejemplo descargando informacion mas reciente.
datos_covid <- datosabiertos

# Casos a nivel nacional
datos_covid <- datos_covid |> chr()
head(datos_covid$`case hospitalization rate`)

# Nacional
\donttest{
datos_covid <- datos_covid |> chr(list_name = "chr_nacional", group_by_entidad = FALSE)
head(datos_covid$`chr_nacional`)

# CHR en IMSS e ISSSTE
datos_covid <- datos_covid |>
  chr(tipo_sector = c("IMSS", "ISSSTE"), list_name = "chimss", group_by_tipo_sector = TRUE)
head(datos_covid$`chimss`)

# Calcula el CHR sobre toda la base
datos_covid <- datos_covid |>
  chr(
    tipo_clasificacion = c(
      "Sospechosos", "Confirmados COVID",
      "Negativo a COVID", "Inv\u00e1lido", "No realizado"
    ),
    group_by_tipo_clasificacion = TRUE, list_name = "chr_todos"
  )
head(datos_covid$`chr_todos`)

# Distinguiendo sólo entre defunciones
datos_covid <- datos_covid |>
  chr(defunciones = TRUE, list_name = "chr_defun")
head(datos_covid$`chr_defun`)

# Si deseas agrupar por una variable que no este en las opciones
datos_covid <- datos_covid |>
  chr(.grouping_vars = c("DIABETES"), list_name = "chr_diab")
head(datos_covid$chr_diab)
}
# Finalmente desconectamos
datos_covid$disconnect()

}
\seealso{
\code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=numero_pruebas]{numero_pruebas()}} \code{\link[=cfr]{cfr()}} \code{\link[=estima_rt]{estima_rt()}}
\code{\link[=positividad]{positividad()}} \code{\link[=casos]{casos()}}
}
