% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/independentSwitchingDCC.R
\name{isdccfit}
\alias{isdccfit}
\title{Fit an Independent Regime Switching Model}
\usage{
isdccfit(R, numRegimes = NA, transMatbounds = c(2, 10), dccBounds = c(0,
  1), w = NA, ...)
}
\arguments{
\item{R}{xts object of asset returns}

\item{numRegimes}{number of regimes to fit to the data}

\item{transMatbounds}{bounds on the parameter tau as described in (Lee, 2010).
Each paramter is defaulted to lie in the range (2,10)}

\item{dccBounds}{bounds on the paramter theta as described in (Lee, 2010).
Each paramter is defaulted to lie in the range (0,1)}

\item{w}{proportion of entries to consider in initializing correlation for
for each regime. It is defualted to split data equally across
all regimes}

\item{...}{addition control paramters that can be passed to the control object
       in DEoptim}
}
\description{
Fit an Independent Regime Switching Model
}
\details{
This method takes in returns data and the number of regimes and fits
sepearate covariances to each regime using the Expectation Maximization
algorithm decribed in (Lee, 2010). IS-DCC model avoids the path dependency
problem observed in other regime switching models and makes the solution more
tractable by running a separate DCC process for each regime.

Fitting the IS-DCC model to data corresponds works in two steps. In the first
step a time varying univariate volatility process, GARCH(1,1) is fitted to
each time series. In the second step DCC parameters for each state
are estimated along with the transition probabilities corresponding to the
Hidden Markov model. This is done by maximising the log-likelihood of
observing the residuals
}
\examples{
\dontrun{
 data("largereturn")
 model <- isdccfit(largesymdata, numRegimes=2, maxiter=50, paralletType=0)
}
}
\author{
Rohit Arora
}
\references{
Lee, H.-T. (2010). Regime switching correlation hedging. Journal of Banking &
}

