% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_grid.R
\name{align_margin}
\alias{align_margin}
\title{Align multiple plots along a specified margin}
\usage{
align_margin(sizes, margin_to_align)
}
\arguments{
\item{sizes}{list of dimensions for each plot being aligned. Each element of list
obtained by a call to \code{grob$heights} or \code{grob$widths} (see example).}

\item{margin_to_align}{string either "first" or "last" for which part of plot area should be aligned.
If vertically aligning, "first" aligns left margin and "last" aligns right margin. If horizontally aligning
"first" aligns top margin and "last" aligns bottom margin}
}
\description{
The function aligns the dimensions of multiple plots along a specified axis, and is solely a helper function
for \code{\link[=align_plots]{align_plots()}} to reduce redundancy. Each element of the \code{sizes}
list corresponds to the dimensions of a plot being aligned. They should be vectors created from calls to
\code{grob$heights} or \code{grob$widths} depending on whether you are aligning vertically or horizontally.
The list of dimensions is generated automatically by the \code{\link[=align_plots]{align_plots()}} function, but see examples.
If the same number of elements exist for all plots for the specified
margin, the function will align individual elements on the margin. Otherwise, it aligns the plot by adding
white space to plot margins so that all margins have the same dimensions.
}
\examples{
# Example for how to utilize, though align_plots() does this internally and automatically
p1 <- qplot(1:10, 1:10)
p2 <- qplot(1:10, (1:10)^2)
p3 <- qplot(1:10, (1:10)^3)
plots <- list(p1, p2, p3)
grobs <- lapply(plots, ggplot2::ggplotGrob)
plot_widths <- lapply(grobs, function(x){x$widths})
# Aligning the Left margins of all plots
aligned_widths <- align_margin(plot_widths, "first")
# Aligning the right margins of all plots as well
aligned_widths <- align_margin(plot_widths, "last")
# Setting the dimensions of plots to the aligned dimensions
for(i in 1:3){
   plots[[i]]$widths <- aligned_widths[[i]]
}
}
