% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aut1(multi).R
\name{multiple.mrc1}
\alias{multiple.mrc1}
\title{Most recent changepoints from mrc method.}
\usage{
multiple.mrc1(mrc, pmax = 10, alpha = 2, elbow.thresh = 0.5,
  n = 144)
}
\arguments{
\item{mrc}{data obtained from mrc.mean1}

\item{pmax}{Maximum number of most recent changepoints
to search for. Default value pmax=10.}

\item{alpha}{The variable  penalty used to penalise
the addition of a given changepoint into a given variable.
Default value alpha = 2.}

\item{elbow.thresh}{default 0.5}

\item{n}{length of series}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints using mrc method consisting
of many related univariate timeseries (Bardwell, Eckley, Fearnhead, and Smith, 2016)
and pools information across the time-series by
solving the K-median problem using tb.raw (Teitz and Bart, 1968).
}
\examples{
#example(right censoring)
library(cpcens)
data("censoredex")
data=censoredex
n=144
N=100
mrc = mrc.mean1( data , beta = 1.5*log(n) )
c = multiple.mrc1( mrc , pmax=10, alpha = 2 , elbow.thresh = 0.5 , n=144)
p.hat = c$MDL
mrc.chpts = c$locs[[p.hat]][ c$affected[[p.hat]] ]
mrc.chpts
}
\seealso{
mrc.mean1
}
