% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_asec}
\alias{get_asec}
\title{Load CPS ASEC microdata}
\usage{
get_asec(
  year,
  vars,
  key = get_key(),
  show_url = FALSE,
  tibble = TRUE,
  convert = TRUE
)
}
\arguments{
\item{year}{Year of data to retrieve.}

\item{vars}{Character vector of variables to retrieve, where each vector
element corresponds to the name of a single variable. Variable names can
be given in uppercase or lowercase but are always made lowercase in the
returned data.}

\item{key}{\href{https://api.census.gov/data/key_signup.html}{Census API key}.
Defaults to environment variable \code{CENSUS_API_KEY}. See the
\href{https://github.com/matt-saenz/cpsR#readme}{README} for info on how
(and why) to set up env var \code{CENSUS_API_KEY}.}

\item{show_url}{If \code{TRUE}, show the URL the request was sent to
(with \code{key} suppressed). Defaults to \code{FALSE}.}

\item{tibble}{If \code{TRUE} (default), return data as a
\href{https://tibble.tidyverse.org}{tibble}. If \code{FALSE}, return data
as a base data frame.}

\item{convert}{If \code{TRUE} (default), run
\code{\link[utils:type.convert]{type.convert()}} with \code{as.is = TRUE}
on the data returned by the Census API. If \code{FALSE}, all columns in
the returned data will be character vectors (exactly as returned by the
Census API).}
}
\value{
A \href{https://tibble.tidyverse.org}{tibble} or base data frame.
}
\description{
\code{get_asec()} loads
\href{https://www.census.gov/data/datasets/time-series/demo/cps/cps-asec.html}{CPS ASEC}
microdata using the Census API.
}
\examples{
\dontrun{

asec21 <- get_asec(2021, vars = c("marsupwt", "spm_poor"))
}

}
