% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanvar.R
\name{cpss.var}
\alias{cpss.var}
\title{Detecting changes in (co)variance}
\usage{
cpss.var(
  dataset,
  algorithm = "BS",
  dist_min = floor(log(n)),
  ncps_max = ceiling(n^0.4),
  pelt_pen_val = NULL,
  pelt_K = 0,
  wbs_nintervals = 500,
  criterion = "CV",
  times = 2,
  mu = NULL
)
}
\arguments{
\item{dataset}{a numeric matrix of dimension \eqn{n\times d}, where each row represents an observation and each column stands for a variable. A numeric vector could also be acceptable for univariate observations.}

\item{algorithm}{a character string specifying the change-point searching algorithm, one of four state-of-the-art candidates "SN" (segment neighborhood), "BS" (binary segmentation), "WBS" (wild binary segmentation) and "PELT" (pruned exact linear time) algorithms.}

\item{dist_min}{an integer indicating the minimum distance between two successive candidate change-points, with a default value \eqn{floor(log(n))}.}

\item{ncps_max}{an integer indicating the maximum number of change-points searched for, with a default value \eqn{ceiling(n^0.4)}.}

\item{pelt_pen_val}{a numeric vector specifying the collection of candidate values of the penalty if the "PELT" algorithm is used.}

\item{pelt_K}{a numeric value to adjust the pruning tactic, usually is taken to be 0 if negative log-likelihood is used as a cost; more details can be found in Killick et al. (2012).}

\item{wbs_nintervals}{an integer indicating the number of random intervals drawn in the "WBS" algorithm and a default value 500 is used.}

\item{criterion}{a character string indicating which model selection criterion, "cross- validation" ("CV") or "multiple-splitting" ("MS"), is used.}

\item{times}{an integer indicating how many times of sample-splitting should be performed; if "CV" criterion is used, it should be set as 2.}

\item{mu}{if a numeric vector or constant is supplied, it would be taken as the value of known overall mean. By default it is set as \code{NULL}, and the common mean of the data is estimated by the sample mean based on the entire data set.}
}
\value{
\code{cpss.var} returns an object of an \proglang{S4} class, called "\code{cpss}", which collects data and information required for further change-point analyses and summaries. See \code{\link{cpss.custom}}.
}
\description{
Detecting changes in (co)variance
}
\examples{
library("cpss")
if (!requireNamespace("MASS", quietly = TRUE)) {
  stop("Please install the package \"MASS\".")
}
set.seed(666)
n <- 1000
tau <- c(200, 500, 750)
mu <- list(rep(0, 2), rep(0, 2), rep(0, 2), rep(0, 2))
Sigma <- list(diag(2), matrix(c(1, 0, 0, 4), 2), matrix(c(1, -0.5, -0.5, 4), 2), diag(2))
seg_len <- diff(c(0, tau, n))
y <- lapply(seq(1, length(tau) + 1), function(k) {
  MASS::mvrnorm(n = seg_len[k], mu = mu[[k]], Sigma = Sigma[[k]])
})
y <- do.call(rbind, y)
res <- cpss.var(y, algorithm = "BS", dist_min = 20)
cps(res)
# [1] 215 515 751
}
\references{
Killick, R., Fearnhead, P., and Eckley, I. A. (2012). Optimal Detection of Changepoints With a Linear Computational Cost. Journal of the American Statistical Association, 107(500):1590–1598.
}
\seealso{
\code{\link{cpss.meanvar}} \code{\link{cpss.mean}}
}
