% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armed_bandit_helpers.R
\name{BatchContextualEpsilonGreedyPolicy}
\alias{BatchContextualEpsilonGreedyPolicy}
\title{Batch Contextual Epsilon-Greedy Policy}
\description{
Batch Contextual Epsilon-Greedy Policy

Batch Contextual Epsilon-Greedy Policy
}
\details{
Implements an epsilon-greedy exploration strategy for contextual bandits with batched updates.
}
\section{Super class}{
\code{cramR::NA}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{epsilon}}{Probability of selecting a random arm (exploration rate).}

\item{\code{batch_size}}{Number of rounds per batch before updating model parameters.}

\item{\code{A_cc}}{List of Gram matrices (one per arm), used to accumulate sufficient statistics across batches.}

\item{\code{b_cc}}{List of reward-weighted context sums (one per arm), updated batch-wise.}

\item{\code{class_name}}{Internal class name identifier.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NA-new}{\code{BatchContextualEpsilonGreedyPolicy$new()}}
\item \href{#method-NA-set_parameters}{\code{BatchContextualEpsilonGreedyPolicy$set_parameters()}}
\item \href{#method-NA-get_action}{\code{BatchContextualEpsilonGreedyPolicy$get_action()}}
\item \href{#method-NA-set_reward}{\code{BatchContextualEpsilonGreedyPolicy$set_reward()}}
\item \href{#method-unknown-clone}{\code{BatchContextualEpsilonGreedyPolicy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="initialize_theta"><a href='../../cramR/html/NA.html#method-NA-initialize_theta'><code>cramR::NA$initialize_theta()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cramR" data-topic="NA" data-id="post_initialization"><a href='../../cramR/html/NA.html#method-NA-post_initialization'><code>cramR::NA$post_initialization()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-new"></a>}}
\if{latex}{\out{\hypertarget{method-NA-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the Batch Epsilon-Greedy policy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualEpsilonGreedyPolicy$new(epsilon = 0.1, batch_size = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epsilon}}{Numeric between 0 and 1. Probability of random arm selection.}

\item{\code{batch_size}}{Integer. Number of observations between parameter updates.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-set_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-NA-set_parameters}{}}}
\subsection{Method \code{set_parameters()}}{
Initializes the parameter structures for each arm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualEpsilonGreedyPolicy$set_parameters(context_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{context_params}}{A list with at least `d` (number of features) and `k` (number of arms).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-get_action"></a>}}
\if{latex}{\out{\hypertarget{method-NA-get_action}{}}}
\subsection{Method \code{get_action()}}{
Chooses an arm based on epsilon-greedy logic and the current estimates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualEpsilonGreedyPolicy$get_action(t, context)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer time step.}

\item{\code{context}}{A list with contextual features and arm count.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the selected action.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NA-set_reward"></a>}}
\if{latex}{\out{\hypertarget{method-NA-set_reward}{}}}
\subsection{Method \code{set_reward()}}{
Updates model statistics based on observed reward. Updates occur once per batch.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualEpsilonGreedyPolicy$set_reward(t, context, action, reward)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{Integer time step.}

\item{\code{context}}{List of contextual features used for the action.}

\item{\code{action}}{A list with the chosen arm.}

\item{\code{reward}}{A list with the observed reward.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated parameter estimates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unknown-clone"></a>}}
\if{latex}{\out{\hypertarget{method-unknown-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BatchContextualEpsilonGreedyPolicy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
