% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{df_to_graph}
\alias{df_to_graph}
\title{Construct the giant component of the network from two data frames}
\usage{
df_to_graph(edgelist, nodelist = NULL, gc = TRUE)
}
\arguments{
\item{edgelist}{A data frame with (at least) two columns: from and to}

\item{nodelist}{NULL, or a data frame with (at least) one column: name, that contains the nodes to include}

\item{gc}{Boolean, if 'TRUE' (default) then the giant component is extracted, if 'FALSE' then the whole graph is returned}
}
\value{
An igraph object & a connected graph
}
\description{
Construct the giant component of the network from two data frames
}
\examples{
from <- c("1", "2", "4")
to <- c("2", "3", "5")
edges <- data.frame(from = from, to = to, stringsAsFactors = FALSE)
nodes <- data.frame(name = c("1", "2", "3", "4", "5"), stringsAsFactors = FALSE)
df_to_graph(edges, nodes)
}
