% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.cranly_network}
\alias{subset.cranly_network}
\title{Subset a \code{\link{cranly_network}} according to author, package and/or directive}
\usage{
\method{subset}{cranly_network}(x, package = Inf, author = Inf,
  maintainer = Inf, directive = c("imports", "suggests", "enhances",
  "depends", "linking_to"), base = TRUE, recommended = TRUE,
  exact = TRUE, only = FALSE, ...)
}
\arguments{
\item{x}{a  \code{\link{cranly_network}} object.}

\item{package}{a vector of character strings with the package names to be matched. Default is \code{\link{Inf}} which returns all available packages in \code{x} for further subsetting.}

\item{author}{a vector of character strings with the author names to be matched. Default is \code{Inf} which returns all available author in \code{x} for further subsetting.}

\item{maintainer}{a vector of character strings with the maintainer names to be matched. Default is \code{Inf} which returns all available maintainers in \code{x} for further subsetting.}

\item{directive}{a vector of at least one of \code{"Imports"}, \code{"Suggests"}, \code{"Enhances"}, \code{"Depends"}.}

\item{base}{logical. Should we include base packages in the subset? Default is \code{TRUE}.}

\item{recommended}{logical. Should we include recommended packages in the subset? Default is \code{TRUE}.}

\item{exact}{logical. Should we use exact matching? Default is \code{TRUE}.}

\item{only}{logical. If \code{TRUE} the subset includes only the edges between packages named in \code{package} and/or authors named in \code{author}. If \code{FALSE} (default) edges to and from all other packages and/or authors that are linked to \code{package} and/or \code{author} are included in the subset.}

\item{...}{currently not used.}
}
\value{
A \code{\link{cranly_network}} object that is the subject of \code{x}.
}
\description{
Subset a \code{\link{cranly_network}} according to author, package and/or directive
}
