% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_path.R
\name{cond_sim}
\alias{cond_sim}
\title{Simulate possible path points conditioned on fit}
\usage{
cond_sim(n = 500, t0, alpha0, t2, alpha2, t1, par, active = 1,
  inf_fac = 1, bm = 0)
}
\arguments{
\item{n}{integer specifying the number of points to return}

\item{t0}{time value for the first location in the segment}

\item{alpha0}{coordinate and velocity values for t0}

\item{t2}{time value for the last location in the segment}

\item{alpha2}{coordinate and velocity values for t2}

\item{t1}{time value for the current location to be simulated}

\item{par}{par values from the crwFit object}

\item{active}{numeric 1 or 0 whether the animal is moving or not (should almost always = 1)}

\item{inf_fac}{Variance inflation factor to increase simulation area}

\item{bm}{boolean whether to draw from a Brownian process}
}
\value{
matrix of coordinate and velocity values drawn
}
\description{
Simulates a set of possible points for a given time conditioned on fit
}
