% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_iv_psi.R
\name{get_iv_all}
\alias{get_iv_all}
\alias{get_iv}
\title{Calculate Information Value (IV)
\code{get_iv}  is used to calculate Information Value (IV) of an independent variable.
\code{get_iv_all} can loop through IV for all specified independent variables.}
\usage{
get_iv_all(dat, x_list = NULL, ex_cols = NULL, breaks_list = NULL,
  target = NULL, pos_flag = NULL, best = TRUE, equal_bins = FALSE,
  tree_control = NULL, bins_control = NULL, g = 10,
  parallel = FALSE, note = FALSE)

get_iv(dat, x, target = NULL, pos_flag = NULL, breaks = NULL,
  breaks_list = NULL, best = TRUE, equal_bins = FALSE,
  tree_control = NULL, bins_control = NULL, g = 10, note = FALSE)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x_list}{Names of independent variables.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{target}{The name of target variable.}

\item{pos_flag}{Value of positive class, Default is "1".}

\item{best}{Logical, merge initial breaks to get optimal breaks for binning.}

\item{equal_bins}{Logical, generates initial breaks for equal frequency binning.}

\item{tree_control}{Parameters of using Decision Tree to segment initial breaks. See detials: \code{\link{get_tree_breaks}}}

\item{bins_control}{Parameters  used to control binning.  See detials: \code{\link{select_best_class}}, \code{\link{select_best_breaks}}}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{x}{The name of an independent variable.}

\item{breaks}{Splitting points for an independent variable. Default is NULL.}
}
\description{
Calculate Information Value (IV)
\code{get_iv}  is used to calculate Information Value (IV) of an independent variable.
\code{get_iv_all} can loop through IV for all specified independent variables.
}
\details{
IV Rules of Thumb for evaluating the strength a predictor
Less than 0.02:unpredictive
0.02 to 0.1:weak
0.1 to 0.3:medium
0.3 + :strong
}
\examples{
get_iv_all(dat = UCICreditCard,
 x_list = names(UCICreditCard)[3:10],
 equal_bins = TRUE, best = FALSE,
 target = "default.payment.next.month",
 ex_cols = "ID|apply_date")
get_iv(UCICreditCard, x = "PAY_3",
       equal_bins = TRUE, best = FALSE,
 target = "default.payment.next.month")
}
\references{
Information Value Statistic:Bruce Lund, Magnify Analytics Solutions, a Division of Marketing Associates, Detroit, MI(Paper AA - 14 - 2013)
}
\seealso{
\code{\link{get_iv}},\code{\link{get_iv_all}},\code{\link{get_psi}},\code{\link{get_psi_all}}
}
