% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_local.R
\name{crew_controller_local}
\alias{crew_controller_local}
\title{Create a controller with a local process launcher.}
\usage{
crew_controller_local(
  name = NULL,
  workers = 1L,
  host = NULL,
  port = NULL,
  seconds_launch = 30,
  seconds_interval = 0.01,
  seconds_timeout = 5,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = 0.1,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  auto_scale = "demand"
)
}
\arguments{
\item{name}{Name of the router object. If \code{NULL}, a name is automatically
generated.}

\item{workers}{Integer, maximum number of parallel workers to run.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::server()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::server()}.}

\item{seconds_exit}{Number of seconds to wait for NNG websockets
to finish sending large data (in case an exit signal is received).
See the \code{exitlinger} argument of \code{mirai::server()}.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::server()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerlaunch} argument of \code{mirai::server()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{auto_scale}{Character of length 1, name of the method for
automatically scaling workers to meet demand. \code{NULL} to default to
\code{"demand"}. Possible values include the following:
\itemize{
\item \code{"demand"}: just after pushing a new task in \code{push()}, launch
\code{min(n, max(0, t - w))} workers, where \code{n} is the maximum number of
workers, \code{t} is the number of queued tasks, and \code{w} is the current
number of workers already running. In other words, scale up the
number of workers to meet the current demand.
If you trust tasks not to crash workers, this is a good choice.
But if you think a task may always crash a worker
(e.g. segmentation fault or maxed out memory) then
this could be somewhat risky because \code{mirai} resubmits
failed tasks behind the scenes and \code{crew} responds by
re-launching workers. If you are worried about this scenario,
choose \code{auto_scale = "one"} instead, which will only launch
up to one worker whenever a task is pushed.
\item \code{"one"}: just after pushing a new task in \code{push()}, launch
a one worker if demand \code{min(n, max(0, t - w))} is greater than 0.
\item \code{"none"}: do not auto-scale at all.
}}
}
\description{
Create an \code{R6} object to submit tasks and
launch workers on local processes.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_local()
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_controller}},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller}()}
}
\concept{controllers}
