% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_assert.R
\name{crew_deprecate}
\alias{crew_deprecate}
\title{Deprecate a \code{crew} feature.}
\usage{
crew_deprecate(name, date, version, alternative)
}
\arguments{
\item{name}{Name of the feature (function or argument) to deprecate.}

\item{date}{Date of deprecation.}

\item{version}{Package version when deprecation was instated.}

\item{alternative}{Message about an alternative.}
}
\value{
\code{NULL} (invisibly). Throws a warning if a feature is deprecated.
}
\description{
Show an informative warning when a \code{crew} feature is
deprecated.
}
\examples{
suppressWarnings(
  crew_deprecate(
    name = "auto_scale",
    date = "2023-05-18",
    version = "0.2.0",
    alternative = "use the scale argument of push(), pop(), and wait()."
  )
)
}
\seealso{
Other utilities: 
\code{\link{crew_assert}()},
\code{\link{crew_eval}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_worker}()}
}
\concept{utilities}
