% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_group.R
\name{crew_controller_group}
\alias{crew_controller_group}
\title{Create a controller group.}
\usage{
crew_controller_group(...)
}
\arguments{
\item{...}{\code{R6} controller objects or lists of \code{R6} controller objects.
Nested lists are allowed, but each element must be a control object
or another list.}
}
\description{
Create an \code{R6} object to submit tasks and launch workers
through multiple \code{crew} controllers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
persistent <- crew_controller_local(name = "persistent")
transient <- crew_controller_local(
  name = "transient",
  tasks_max = 1L
)
group <- crew_controller_group(persistent, transient)
group$start()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$terminate()
}
}
\seealso{
Other user: 
\code{\link{crew-package}},
\code{\link{crew_clean}()},
\code{\link{crew_controller_local}()},
\code{\link{crew_tls}()}
}
\concept{user}
