% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/hierclustering.R
\name{crimeClust_hier}
\alias{crimeClust_hier}
\title{Agglomerative Hierarchical Crime Series Clustering}
\usage{
crimeClust_hier(crimes, varnames, estimateBF, linkage = c("average", "single",
  "complete"), ...)
}
\arguments{
\item{crimes}{data.frame of crime incidents}

\item{varnames}{the variable names necessary for getting evidence variables}

\item{estimateBF}{function to estimate the bayes factor from evidence variables}

\item{linkage}{the type of linkage for hierarchical clustering
  \itemize{
    \item \dQuote{average} uses the average bayes factor
    \item \dQuote{single} uses the largest bayes factor (most similar)
    \item \dQuote{complete} uses the smallest bayes factor (least similar)
  }}

\item{\ldots}{other arguments passed to \code{\link{compareCrimes}}}
}
\value{
An object of class \code{hclust} (from \code{\link{hclust}}).
}
\description{
Run hierarchical clustering on a set of crimes using the log Bayes Factor as
the similarity metric.
}
\details{
This function first compares all crime pairs using \code{\link{compareCrimes}},
   then uses \code{estimateBF} to estimate the log Bayes factor for every pair.
   Next, it passes this information into \code{\link{hclust}} to carry out the
   agglomerative hierarchical clustering. Because \code{\link{hclust}} requires
   a dissimilarity, this uses the negative log Bayes factor.
}
\examples{
# See vignette: "Crime Series Identification and Clustering" for usage.
}
\references{
Porter, M. D. (2014). A Statistical Approach to Crime Linkage.
   \emph{arXiv preprint arXiv:1410.2285.}.
 \url{http://arxiv.org/abs/1410.2285}
}
\seealso{
\code{\link{clusterPath}, \link{plot_hcc}}
}

