% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{naiveBayes}
\alias{naiveBayes}
\alias{naiveBayes.fit}
\title{Naive bayes classifier using histograms and shrinkage}
\usage{
naiveBayes(formula, data, weights, df = 20, nbins = 30,
  partition = c("quantile", "width"))

naiveBayes.fit(X, y, weights, df = 20, nbins = 30,
  partition = c("quantile", "width"))
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be
  coerced to that class): a symbolic description of the model to be fitted.
  Only main effects (not interactions) are allowed.}

\item{data}{data.frame of predictors, can include continuous and
  categorical/factors along with a response vector (1 = linked, 0 = unlinked),
  and (optionally) observation weights (e.g., \code{weight} column).
  The column names of data need to include the terms specified in \code{formula}.}

\item{weights}{a vector of observation weights or the column name in
  \code{data} that corresponds to the weights.}

\item{df}{the degrees of freedom for each component density. if vector, each
  predictor can use a different df}

\item{nbins}{the number of bins for continuous predictors}

\item{partition}{for binning; indicates if breaks generated from quantiles
  or equal spacing}

\item{X}{data frame of categorical and/or numeric variables}

\item{y}{binary vector indicating linkage (1 = linked, 0 = unlinked) or
       logical vector (TRUE = linked, FALSE = unlinked)}
}
\value{
BF a bayes factor object; list of component bayes factors
}
\description{
After binning, this adds pseudo counts to each bin count to give
 df approximate degrees of freedom. If partition=quantile, this does not
 assume a continuous uniform prior over support, but rather a discrete uniform
 over all (unlabeled) observations points.
}
\details{
Fits a naive bayes model to continous and categorical/factor predictors.
   Continous predictors are first binned, then estimates shrunk towards zero.
}
\examples{
# See vignette: "Statistical Methods for Crime Series Linkage" for usage.
}
\seealso{
\code{\link{predict.naiveBayes}}, \code{\link{plot.naiveBayes}}
}

